% finaquant Financial Analytics - www.finaquant.com
% Copyright: Tunc Ali Ktkcoglu 2012, version: 24April2012
% Function: Calculates all fees for a single period
% Related web page:
% http://finaquant.com/fee-calculator-and-analyzer-for-share-classes-of-mutual-funds-1-calculation/991
function ResultVector = FeeCalculator_SinglePeriod(...
    FrondEndLoadRates,              ...
    BackEndLoadCDSCRates,           ...
    AnnualDistributionFeeRate,      ...
    AnnualManagementFeeRates,       ...
    MngFeeScaleLogic,               ...
    OtherAnnualServiceFeeRates,     ...
    OtherSubscriptionFeeRates,      ...
    OtherRedemptionFeeRates,        ...
    AssumedFundReturn,              ...
    AssetVolume,                    ...
    NumShares,                      ...     % number of shares
    CurrentPeriod,                  ...
    N)      % total number of calculation periods

% initiate result vector for storing all results
ResultVector = zeros(1, 13);

% front-end load
if CurrentPeriod == 1
    EffectiveFeeRate = calculate_fee_scale(AssetVolume, FrondEndLoadRates, 'class');
    FrondEndLoad = EffectiveFeeRate * AssetVolume / 100; 
else
    FrondEndLoad = 0;
end
ResultVector(1) = FrondEndLoad;
  
% other subscription fees
if CurrentPeriod == 1
    OtherSubscriptionFees = OtherSubscriptionFeeRates(1) * AssetVolume / 100 ...
        + OtherSubscriptionFeeRates(2)* NumShares;
else
    OtherSubscriptionFees = 0;
end
ResultVector(2) = OtherSubscriptionFees;

% Remaining asset value after front-end and other subscription fees
AssetVolumeAfterSubscriptionFees = AssetVolume - FrondEndLoad - OtherSubscriptionFees;
ResultVector(3) = AssetVolumeAfterSubscriptionFees;

% Period-end asset value before management and service fees
ResultVector(4) = AssumedFundReturn;
AssetVolumeBeforeManagementFees = AssetVolumeAfterSubscriptionFees * (1 + AssumedFundReturn/100);
ResultVector(5) = AssetVolumeBeforeManagementFees;

% Management fees in %
EffectiveMngFeeRate = calculate_fee_scale(AssetVolumeBeforeManagementFees, AnnualManagementFeeRates, MngFeeScaleLogic);
ResultVector(6) = EffectiveMngFeeRate;

ManagementFee = EffectiveMngFeeRate * AssetVolumeBeforeManagementFees / 10000; % mng fee rate in BP
ResultVector(7) = ManagementFee;

% Annual distribution fees in %
AnnualistributionFees = AnnualDistributionFeeRate * AssetVolumeBeforeManagementFees / 100;
ResultVector(8) = AnnualistributionFees;

% Other annual service fees in BP
AnnualServiceFees = OtherAnnualServiceFeeRates(1) * AssetVolumeBeforeManagementFees / 10000 ...
    + OtherAnnualServiceFeeRates(2) * NumShares;
ResultVector(9) = AnnualServiceFees;

% Asset value before redemption fees
AssetVolumeBeforeRedemptionFees = AssetVolumeBeforeManagementFees - ManagementFee - AnnualistributionFees - AnnualServiceFees;
ResultVector(10) = AssetVolumeBeforeRedemptionFees;

% Back-end load with CDSC
if N == CurrentPeriod && N <= length(BackEndLoadCDSCRates)
    BackEndLoadCDSC = BackEndLoadCDSCRates(N) * AssetVolumeBeforeRedemptionFees / 100;
else
    BackEndLoadCDSC = 0;
end
ResultVector(11) = BackEndLoadCDSC;

% Other redemption fees
if N == CurrentPeriod
    OtherRedemptionFees = OtherRedemptionFeeRates(1) * AssetVolumeBeforeRedemptionFees / 100 ...
        + OtherRedemptionFeeRates(2) * NumShares;
else
    OtherRedemptionFees = 0;
end 
ResultVector(12) = OtherRedemptionFees;

% Asset value after redemption fees
AssetVolumeAfterRedemptionFees = AssetVolumeBeforeRedemptionFees - BackEndLoadCDSC - OtherRedemptionFees;
ResultVector(13) = AssetVolumeAfterRedemptionFees;

end     % function